@echo off
setlocal

:main
echo Starting main launch flow...
call :check_megapicker_installed 

if "%megapicker_installed%"=="0x0" (
    echo Installing The Jackbox Megapicker...
    call :launch_megapicker
    call :wait_for_installation   
)

call :wait_for_protocol_handler
set "gameID=%~1"
call :launch_game %gameID%
goto :eof

:check_megapicker_installed
set "regPath=HKEY_CURRENT_USER\Software\Valve\Steam\Apps\2828500"
set "status="
echo Checking if The Jackbox Megapicker is installed...
:: Try to query the registry and handle errors if the key does not exist
for /f "tokens=3" %%a in ('reg query "%regPath%" /v "Installed" 2^>nul') do (
    set "status=%%a"
)
if defined status (
    :: Set the installed status based on the value read from the registry
    set "megapicker_installed=%status%"
) else (
    set "megapicker_installed=0x0"  :: Treat as not installed
)
exit /b

:launch_megapicker
start steam://run/2828500
exit /b

:check_protocol_handler
set "protocol=jackbox"
reg query "HKEY_CLASSES_ROOT\%protocol%" >nul 2>&1
exit /b %errorlevel%

:wait_for_protocol_handler
echo Waiting for Jackbox protocol registration...
:wait_loop
timeout /t 2 >nul 

call :check_protocol_handler
if errorlevel 1 (
    :: Launch the Megapicker if it's not running, to ensure the protocol handler is registered
    call :check_megapicker_running
    if "%megapicker_running%"=="0" (
        echo Launching The Jackbox Megapicker to register protocol...
        call :launch_megapicker
    )
    goto wait_loop
)
exit /b 

:check_megapicker_running
set "megapicker_running=0"
tasklist | findstr /i "The Jackbox Megapicker.exe" >nul 2>&1
if %errorlevel% equ 0 (
    set "megapicker_running=1"
)
exit /b

:launch_game
echo Launching %~1 via The Jackbox Megapicker...
start jackbox://%~1
exit /b

:wait_for_installation
timeout /t 1 >nul
call :check_megapicker_installed
if "%megapicker_installed%"=="0x0" (
    goto wait_for_installation
)
exit /b